/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.ritual.features;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.ritual.FeaturePlacementRitual;
import com.hollingsworth.arsnouveau.api.ritual.features.IPlaceableFeature;
import com.hollingsworth.arsnouveau.common.block.tile.RitualBrazierTile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import oshi.util.tuples.Pair;

public class CocoaFeature
implements IPlaceableFeature {
    double distance;
    double chance;
    List<BlockState> cocoaStates = new ArrayList<BlockState>();

    public CocoaFeature(double distance, double chance) {
        this.distance = distance;
        this.chance = chance;
        BlockState state = Blocks.COCOA.defaultBlockState();
        BlockState north = (BlockState)state.setValue((Property)CocoaBlock.FACING, (Comparable)Direction.NORTH);
        BlockState south = (BlockState)state.setValue((Property)CocoaBlock.FACING, (Comparable)Direction.SOUTH);
        BlockState east = (BlockState)state.setValue((Property)CocoaBlock.FACING, (Comparable)Direction.EAST);
        BlockState west = (BlockState)state.setValue((Property)CocoaBlock.FACING, (Comparable)Direction.WEST);
        this.cocoaStates.add(north);
        this.cocoaStates.add(south);
        this.cocoaStates.add(east);
        this.cocoaStates.add(west);
    }

    @Override
    public double distanceFromOthers() {
        return this.distance;
    }

    @Override
    public boolean onPlace(Level level, BlockPos pos, FeaturePlacementRitual placementRitual, RitualBrazierTile brazierTile) {
        for (BlockState state : this.cocoaStates) {
            if (!((double)level.random.nextFloat() < this.chance) || !state.canSurvive((LevelReader)level, pos)) continue;
            Item item = state.getBlock().asItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                blockItem.place(new BlockPlaceContext(level, (Player)ANFakePlayer.getPlayer((ServerLevel)level), InteractionHand.MAIN_HAND, new ItemStack((ItemLike)blockItem), new BlockHitResult(new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), Direction.DOWN, pos, false)));
            }
            return true;
        }
        return false;
    }

    @Override
    public String getFeatureName() {
        return "cocoa";
    }

    @Override
    public Pair<BlockPos, BlockPos> getCustomOffsets() {
        return new Pair((Object)BlockPos.ZERO, (Object)new BlockPos(0, 10, 0));
    }
}

